<?php
// api.php
// https://apis.kontroles.com/auth/api_role.php?p_session_id=1012517

require '../headers.php';
require '../authdb.php';

try {
    // Crear una conexi贸n con PDO
    $dsn = "pgsql:host=" . DB_HOST . ";dbname=" . DB_NAME;
    $pdo = new PDO($dsn, DB_USER, DB_PASS, [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]);
    $stmt = $pdo->prepare("SELECT apicore_getmenu AS jsontxt FROM logic.apicore_getmenu(:p_session_id)");

    // Bind parameters securely
    $stmt->bindParam(':p_session_id', $_GET['p_session_id'], PDO::PARAM_INT);
    $stmt->execute();

    $result = $stmt->fetch(PDO::FETCH_ASSOC);  // Assuming you want an associative array

    if ($result) {
/***********
        $response = json_decode($result['jsontxt']);
************/
        // Decode the JSON string into a PHP array
        $data = json_decode($result['jsontxt'], true);

        // Access the 'data' array
        $menuItems = $data['data'];
        
        // Function to recursively traverse the menu items and extract data
            $html = '<head>
                          <meta charset="UTF-8">
                          <meta name="viewport" content="width=device-width, initial-scale=1.0">
                          <title>Kontroles ERP</title>';
$html .= '
  <style>
    body {
      margin: 0;
      font-family: Arial, sans-serif;
    }

    /* Navbar fijo */
    .navbar {
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 60px;
      background-color: #2c3e50;
      color: white;
      display: flex;
      align-items: center;
      justify-content: space-between;
      padding: 0px;
      z-index: 1000;
      box-shadow: 0px 2px 5px rgba(0, 0, 0, 0.3);
    }

    .navbar h1 {
      margin: 0;
      font-size: 18px;
    }

    .menu-toggle {
      display: flex;
      align-items: center;
      cursor: pointer;
    }

    .menu-toggle label {
      display: block;
      width: 40px;
      height: 40px;
      background-color: #1abc9c;
      color: white;
      text-align: center;
      line-height: 40px;
      border-radius: 5px;
      font-size: 20px;
      box-shadow: 0 2px 5px rgba(0, 0, 0, 0.3);
    }

    .menu-toggle input {
      display: none;
    }

    /* Sidebar base */
    .sidebar {
      width: 228px;
      height: 100vh;
      background-color: #34495e;
      color: white;
      position: fixed;
      top: 60px; /* Ajusta debajo del navbar */
      left: 0px; /* Oculta la sidebar por defecto */
      padding: 10px;
      overflow-y: auto; 
      box-shadow: 3px 0 5px rgba(0, 0, 0, 0.2);
      transition: all 0.3s ease;
      z-index: 999;
    }
    
    .no-scrollbar {
      -ms-overflow-style: none; /* IE and Edge */
      scrollbar-width: none; /* Firefox */
    }
    
    .no-scrollbar::-webkit-scrollbar {
      display: none; /* Chrome, Safari and Opera */
    }

    .menu-toggle input:checked ~ .sidebar {
      left: 0; /* Muestra la sidebar */
    }

    .sidebar h2 {
      text-align: center;
      margin-bottom: 20px;
    }

    .sidebar ul {
      list-style: none;
      padding: 0;
      margin: 0;
    }

    .sidebar ul li {
      margin: 5px 0;
    }

    .sidebar ul li a,
    .sidebar ul li label {
      display: block;
      text-decoration: none;
      color: white;
      padding: 10px;
      background-color: #3b5998;
      border-radius: 5px;
      cursor: pointer;
    }

    .sidebar ul li a:hover,
    .sidebar ul li label:hover {
      background-color: #5d82c6;
    }

    .sidebar ul li ul {
      display: none;
      padding-left: 20px;
    }

    .sidebar ul li input[type="checkbox"] {
      display: none;
    }

    .sidebar ul li input[type="checkbox"]:checked + ul {
      display: block;
    }

    .sidebar ul li ul li a {
      background-color: #1abc9c;
    }

    .sidebar ul li ul li a:hover {
      background-color: #16a085;
    }

    /* Media query para pantallas pequeñas (móviles) */
    @media (max-width: 768px) {
      .menu-toggle {
        display: flex;
        justify-content: flex-end;
      }

      .sidebar {
        left: auto;
        right: -300px; /* Oculta la sidebar en móviles */
        box-shadow: -3px 0 5px rgba(0, 0, 0, 0.2);
      }

      .menu-toggle input:checked ~ .sidebar {
        right: 0; /* Muestra la sidebar a la derecha en móviles */
      }
    }

    /* Contenido principal */
    .content {
/*      padding: 70px 0px 800px 250px; / * Agrega espacio debajo del navbar */

      width: calc(100vw - 260px); /* 100% del ancho de la ventana menos el ancho del sidebar */
      height: calc(100vh - 70px); /* 100% del alto de la ventana menos la altura del navbar */
      margin-top: 70px; /* Espacio para el navbar */
      margin-left: 260px; /* Espacio para el sidebar */
      padding: 5px; /* Añadir un poco de padding al contenido */
      box-sizing: border-box; /* Para que el padding no afecte al ancho total */
      position: fixed;
    }
    
    out-toggle {
      display: none;
      margin-left: 260px; /* Espacio para el sidebar */
    }
    
  </style>
';  
  
  

$html .= '  </head><body>';
            $h_t_m_l = '<div class="navbar">
                            <a href="index.php" class="logo-pc">
                              <img src="../assets/images/newKontrolesERP.png" alt="logo"/>
                            </a>
                            <a href="index.php" class="logo-movil">
                              <img src="../assets/images/iconoKontrolesERP.png" alt="logo" width="10%" />
                            </a>            
                            <div class="menu-toggle">
                                <input type="checkbox" id="menu-checkbox">
                                <label for="menu-checkbox">☰</label>
                            </div>
                      </div>';
/*  NAVBAR  */
            $html .= '  <div class="navbar">
                            <a href="index.php" style="color: white; font: italic small-caps bold 24px/48px Georgia, serif; text-decoration: none;">Kontroles ERP</a>
                            <div class="out-toggle">
                                  <label for="out-checkbox">></label>
                                  <input type="checkbox" id="out-checkbox">
                            </div>
                            <div class="menu-toggle">
                                  <label for="menu-checkbox">☰</label>
                                  <input type="checkbox" id="menu-checkbox">
                            </div>
                      </div>';
/*  SIDEBAR  */
            $html .= '<div class="sidebar">';
            $html .= '                  
            <div id="info">
                <i style="font-size: 10px;">Rol:</i><select id="roleDropdown"></select>
                <br>
                <i style="font-size: 10px;">Sucursal:</i><select id="orgDropdown"></select>
                <br>';
$html1 = '     <i style="font-size: 10px;">Idioma:</i>
                <select id="languageDropdown">
                    <option value="es_ES">Español</option>
                    <option value="en_US">English</option>
                </select>';
            $html .=    '</div>';

            $html .= '<div id="dynamic"><ul id="menu_ul">';
            foreach ($menuItems as $item1) {
                if ($item1['title'] !== 'KontrolesERP') {
                    if (isset($item1['submenu']) && !empty($item1['submenu'])) {
                        $html .= '<li id="' . $item1['id'] . '_li1">
                                    <label for="' . $item1['id'] . '_label1">' . $item1['title'] . '</label>
                                    <input type="checkbox" id="' . $item1['id'] . '_label1">';
                        $html .= '<ul id="' . $item1['id'] . '_ul1">';
                        foreach ($item1['submenu'] as $item2) {
                            if (isset($item2['submenu']) && !empty($item2['submenu'])) {
                                $html .= '<li id="' . $item2['id'] . '_li2">
                                            <label for="' . $item2['id'] . '_label2">' . $item2['title'] . '</label>
                                            <input type="checkbox" id="' . $item2['id'] . '_label2">';
                                $html .= '<ul id="' . $item2['id'] . '_ul2">';
                                foreach ($item2['submenu'] as $item3) {
                                    if (isset($item3['submenu']) && !empty($item3['submenu'])) {
                                        $html .= '<li id="' . $item3['id'] . '_li3">
                                                    <label for="' . $item3['id'] . '_label3">' . $item3['title'] . '</label>
                                                    <input type="checkbox" id="' . $item3['id'] . '_label3">';
                                        $html .= '<ul id="' . $item3['id'] . '_ul3">';
                                        foreach ($item3['submenu'] as $item4) {
                                            if (isset($item4['submenu']) && !empty($item4['submenu'])) {
                                                $html .= '<li id="' . $item4['id'] . '_li4">
                                                            <label for="' . $item4['id'] . '_label4">' . $item4['title'] . '</label>
                                                            <input type="checkbox" id="' . $item4['id'] . '_label4">';
                                                $html .= '<ul id="' . $item4['id'] . '_ul4">';
                                                foreach ($item4['submenu'] as $item5) {
                                                    $html .= '<li id="' . $item5['id'] . '_li5">
                                                                <a id="' . $item5['id'] . '_a5" onclick="getWindow(' . $item5['path'] . '); getTab(220, 0, 0, 10, `{}`); return false;">' . $item5['title'] . '</a>
                                                            </li>';
                                                }
                                                $html .=  '</ul>';
                                            } else {
                                                $html .= '<a id="' . $item4['id'] . '_a4" onclick="getWindow(' . $item4['path'] . '); getTab(220, 0, 0, 10, `{}`); return false;">' . $item4['title'] . '</a>';
                                            }
                                            $html .=  '</li>';
                                        }
                                        $html .=  '</ul>';
                                    } else {
                                        $html .= '<a id="' . $item3['id'] . '_a3" onclick="getWindow(' . $item3['path'] . '); getTab(220, 0, 0, 10, `{}`); return false;">' . $item3['title'] . '</a>';
                                    }
                                    $html .=  '</li>';
                                }
                                $html .=  '</ul>';
                            } else {
                                $html .= '<a id="' . $item2['id'] . '_a2" onclick="getWindow(' . $item2['path'] . '); getTab(220, 0, 0, 10, `{}`); return false;">' . $item2['title'] . '</a>';
                            }
                            $html .=  '</li>';
                        }
                        $html .=  '</ul>';
                    } else {
                        $html .= '<a id="' . $item1['id'] . '_a1" onclick="getWindow(' . $item1['path'] . '); getTab(220, 0, 0, 10, `{}`); return false;>' . $item1['title'] . '</a>';
                    }
                    $html .=  '</li>';
                }
            }
            $html .= '</ul></div>';
            $html .= '</div>';
            $html .= '<div class="content" id="divContentForIframe1"></div>';
            header('Content-Type: application/text');
            echo $html;
    } else {
        $response = ["data" => [
                    "code" => 401,
                    "message"=> "Credenciales inválidas (apicore_getmenu)"
                ]];
    }
    // Enviar la respuesta como JSON
/***********
    header('Content-Type: application/json');
    echo json_encode($response);
************/
} catch (PDOException $e) {
    // Manejo de errores
    echo json_encode(['error' => 'Error de conexion a la base de datos (apicore_getmenu)']);
    error_log("Error de conexion: (apicore_getmenu)" . $e->getMessage());
}
?>
