<?php
// api.php
// https://apis.kontroles.com/userauth.php?p_client_id=1000000&p_user=arodriguez@inrocar.com&p_pass=112233&p_lang=en_US&p_app=kERPphp

require '../headers.php';
require '../authdb.php';

try {
    // Crear una conexión con PDO
    $dsn = "pgsql:host=" . DB_HOST . ";dbname=" . DB_NAME;
    $pdo = new PDO($dsn, DB_USER, DB_PASS, [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]);
    $stmt = $pdo->prepare("SELECT apicore_authlogin AS jsontxt FROM logic.apicore_authlogin(:p_client_id, :p_user, :p_pass, :p_lang, :p_app)");

    // Bind parameters securely
    $stmt->bindParam(':p_client_id', $_GET['p_client_id'], PDO::PARAM_INT);
    $stmt->bindParam(':p_user', $_GET['p_user'], PDO::PARAM_STR);
    $stmt->bindParam(':p_pass', $_GET['p_pass'], PDO::PARAM_STR);
    $stmt->bindParam(':p_lang', $_GET['p_lang'], PDO::PARAM_STR);
    $stmt->bindParam(':p_app', $_GET['p_app'], PDO::PARAM_STR);
    $stmt->execute();

    $result = $stmt->fetch(PDO::FETCH_ASSOC);  // Assuming you want an associative array

    if ($result) {
        $response = json_decode($result['jsontxt']);
    } else {
        $response = ["data" => [
                    "code" => 401,
                    "message"=> "Credenciales invlidas"
                ]];
    }
    // Enviar la respuesta como JSON
    header('Content-Type: application/json');
    echo json_encode($response);
    
} catch (PDOException $e) {
    // Manejo de errores
    echo json_encode(['error' => 'Error de conexion a la base de datos (endpoint: auth/api_user.php)']);
    error_log("Error de conexion: " . $e->getMessage());
}
?>
