<?php
// api.php
$sqlcompleto = "select td_anio, td_mes, sum(td_reterenta) as reterenta, sum(td_vta_cf) as vtaccf, sum(td_iva_cf) as impccf, sum(td_vta_fa) as vtafac, sum(td_iva_fa) as impfac, sum(td_vta_nc) as descndc, sum(td_iva_nc) as impndc, sum(td_vta_ex) as vtaexp
                            from dtes.pdfs_view
                            group by td_anio, td_mes
                            ";

require '../headers.php';
require '../authdb.php';

try {
    // Crear una conexi贸n con PDO
    $dsn = "pgsql:host=" . DB_HOST . ";dbname=" . DB_NAME;
    $pdo = new PDO($dsn, DB_USER, DB_PASS, [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]);
    $stmt = $pdo->prepare("select td_anio, td_mes, sum(td_vta_cf) as vtaccf, sum(td_vta_fa) as vtafac, sum(td_vta_nc) as descndc, sum(td_vta_ex) as vtaexp, :p_session_id
                            from dtes.pdfs_view
                            group by td_anio, td_mes
                            ");

    // Bind parameters securely
    $stmt->bindParam(':p_session_id', $_GET['p_session_id'], PDO::PARAM_INT);
    $stmt->execute();

    $result = $stmt->fetch(PDO::FETCH_ASSOC);  // Assuming you want an associative array

    if ($result) {
/***********
        $response = json_decode($result['jsontxt']);
************/
        // Decode the JSON string into a PHP array
        $data = json_decode($result['jsontxt'], true);

        // Access the 'data' array
        $menuItems = $data['data'];
        
        // Function to recursively traverse the menu items and extract data
            $html = '<div class="content">
                        <canvas id="ventasChart"></canvas>
                    </div>';
            header('Content-Type: application/text');
            echo $html;
    } else {
        $response = ["data" => [
                    "code" => 401,
                    "message"=> "Credenciales inválidas (apicore_getmenu)"
                ]];
    }
    // Enviar la respuesta como JSON
/***********
    header('Content-Type: application/json');
    echo json_encode($response);
************/
} catch (PDOException $e) {
    // Manejo de errores
    echo json_encode(['error' => 'Error de conexion a la base de datos (apicore_getmenu)']);
    error_log("Error de conexion: (apicore_getmenu)" . $e->getMessage());
}
?>
