<?php
// api.php
// https://apis.kontroles.com/auth/api_role.php?p_session_id=1012517

require '../headers.php';
require '../authdb.php';

try {
    // Crear una conexi贸n con PDO
    $dsn = "pgsql:host=" . DB_HOST . ";dbname=" . DB_NAME;
    $pdo = new PDO($dsn, DB_USER, DB_PASS, [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]);
    $stmt = $pdo->prepare("SELECT apicore_getinfosession AS jsontxt FROM logic.apicore_getinfosession(:p_session_id)");

    // Bind parameters securely
    $stmt->bindParam(':p_session_id', $_GET['p_session_id'], PDO::PARAM_INT);
    $stmt->execute();

    $result = $stmt->fetch(PDO::FETCH_ASSOC);  // Assuming you want an associative array

    if ($result) {
        $response = json_decode($result['jsontxt']);
    } else {
        $response = ["data" => [
                    "code" => 401,
                    "message"=> "Credenciales inválidas"
                ]];
    }
    // Enviar la respuesta como JSON
    header('Content-Type: application/json');
    echo json_encode($response);
} catch (PDOException $e) {
    // Manejo de errores
    echo json_encode(['error' => 'Error de conexion a la base de datos']);
    error_log("Error de conexion: " . $e->getMessage());
}
?>
