<?php
// api.php
// https://apis.kontroles.com/auth/api_role.php?p_session_id=1012517

require '../headers.php';
require '../authdb.php';


try {
    // Crear una conexion con PDO
    $dsn = "pgsql:host=" . DB_HOST . ";dbname=" . DB_NAME;
    $pdo = new PDO($dsn, DB_USER, DB_PASS, [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]);
    $stmt = $pdo->prepare("SELECT apicore_getcatalogs AS jsontxt FROM logic.apicore_getcatalogs(:p_session_id::integer, :p_tablename::text, :p_fields::text)");

    $id1 = '1012584';
    $p_table = 'm_product_category';
    $p_fields = '{"name":"", "value":""}';

    // Bind parameters securely
    $stmt->bindParam(':p_session_id',   $id1,       PDO::PARAM_INT);
    $stmt->bindParam(':p_tablename',    $p_table,   PDO::PARAM_STR);
    $stmt->bindParam(':p_fields',       $p_fields,  PDO::PARAM_STR);
    $stmt->execute();

    $result = $stmt->fetch(PDO::FETCH_ASSOC);  // Assuming you want an associative array

    if ($result) {
        // Decode the JSON string into a PHP array
        $data = json_decode($result['jsontxt'], true);

        // Access the 'data' array
        $contentsItems = $data['contents'];
        
        // Function to recursively traverse the menu items and extract data
            $html = '
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Sistema de Facturacin</title>
  <style>
/* General */
body {
  font-family: Arial, sans-serif;
  margin: 0;
  padding: 0;
  background-color: #f9f9f9;
}

.invoice-container {
  padding: 10px;
  max-width: 480px;
  margin: 0 auto;
  background-color: #ffffff;
  border-radius: 8px;
  box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
}

/* Encabezado */
.invoice-header {
  text-align: center;
  margin-bottom: 20px;
}

.invoice-header h1 {
  font-size: 20px;
  margin: 0;
}

.invoice-header p {
  font-size: 14px;
  color: #555;
}

/* Secciones */
section {
  margin-bottom: 20px;
}

section h2 {
  font-size: 16px;
  margin-bottom: 10px;
}

/* Inputs */
label {
  display: block;
  margin-bottom: 10px;
}

input[type="text"],
input[type="number"],
select {
  width: 100%;
  padding: 8px;
  margin-top: 5px;
  border: 1px solid #ddd;
  border-radius: 4px;
  font-size: 14px;
}

input[readonly] {
  background-color: #f4f4f4;
}

/* Productos */
.products-list .product-row {
  display: flex;
  align-items: center;
  gap: 10px;
  margin-bottom: 10px;
}

.product-select,
.product-quantity,
.product-price {
  flex: 1;
}

.remove-btn {
  padding: 5px 10px;
  background-color: #dc3545;
  color: #fff;
  border: none;
  border-radius: 4px;
  cursor: pointer;
}

.add-product-btn {
  width: 100%;
  padding: 10px;
  background-color: #007bff;
  color: #fff;
  border: none;
  border-radius: 4px;
  cursor: pointer;
}

.add-product-btn:hover {
  background-color: #0056b3;
}

/* Totales */
.totals .total-row {
  display: flex;
  justify-content: space-between;
  margin-bottom: 10px;
}

.total {
  font-weight: bold;
  font-size: 16px;
}

/* Pago */
.payment .generate-invoice-btn {
  width: 100%;
  padding: 10px;
  background-color: #28a745;
  color: #fff;
  border: none;
  border-radius: 4px;
  cursor: pointer;
}

.payment .generate-invoice-btn:hover {
  background-color: #218838;
}
      
  </style>
</head>
<body>
  <div class="invoice-container">
    <!-- Encabezado - ->
    <header class="invoice-header">
      <h1>Sistema de Facturacin</h1>
      <p>Empresa XYZ</p>
    </header>
-->

    <!-- Datos del cliente -->
    <section class="customer-info">
      <h2>Datos del Cliente</h2>
      <label>
        Nombre:
        <input type="text" name="customer_name" placeholder="Ej. Juan Prez">
      </label>
<!--
      <label>
        Direccin:
        <input type="text" name="customer_address" placeholder="Ej. Calle Principal #123">
      </label>
      <label>
        Telfono:
        <input type="text" name="customer_phone" placeholder="Ej. 555-1234">
      </label>
-->
    </section>

    <!-- Productos -->
    <section class="products-list">
      <h2>Productos/Servicios</h2>
      <div class="product-row">
        <select name="product[]" class="product-select">
          <option value="prod1">Producto 1</option>
          <option value="prod2">Producto 2</option>
          <option value="prod3">Producto 3</option>
        </select>
        <input type="number" name="quantity[]" class="product-quantity" placeholder="Cantidad" min="1">
        <input type="text" name="price[]" class="product-price" placeholder="Precio Unitario">
        <button class="remove-btn">X</button>
      </div>
      <button class="add-product-btn">+ Agregar Producto</button>
    </section>

    <!-- Totales -->
    <section class="totals">
      <h2>Totales</h2>
      <div class="total-row">
        <span>Subtotal:</span>
        <span id="subtotal">$0.00</span>
      </div>
      <div class="total-row">
        <span>IVA (15%):</span>
        <span id="tax">$0.00</span>
      </div>
      <div class="total-row total">
        <span>Total:</span>
        <span id="total">$0.00</span>
      </div>
    </section>

    <!-- Pago -->
    <section class="payment">
      <h2>Pago</h2>
      <label>
        Efectivo:
        <input type="text" name="payment_cash" placeholder="Ej. $100.00">
      </label>
      <label>
        Cambio:
        <input type="text" name="payment_change" id="payment-change" readonly>
      </label>
      <button class="generate-invoice-btn">Generar Factura</button>
    </section>
  </div>
</body>
</html>
                    ';
            header('Content-Type: application/text');
            echo $html;
    } else {
        $response = ["data" => [
                    "code" => 401,
                    "message"=> "Credenciales inválidas (api_getTab)"
                ]];
    }
    // Enviar la respuesta como JSON
/***********
    header('Content-Type: application/json');
    echo json_encode($response);
************/
} catch (PDOException $e) {
    // Manejo de errores
    echo json_encode(['error' => 'Error de conexion a la base de datos (api_getTab)']);
    error_log("Error de conexion: (api_getTab)" . $e->getMessage());
}
?>
