<?php
// api.php
// https://apis.kontroles.com/auth/api_role.php?p_session_id=1012517

require '../headers.php';
require '../authdb.php';

try {
    // Crear una conexi贸n con PDO
    $dsn = "pgsql:host=" . DB_HOST . ";dbname=" . DB_NAME;
    $pdo = new PDO($dsn, DB_USER, DB_PASS, [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]);
    $stmt = $pdo->prepare("SELECT apicore_getwindowbyid AS jsontxt FROM logic.apicore_getwindowbyid(:p_window_id::integer, :p_session_id::integer)");

    // Bind parameters securely
    $stmt->bindParam(':p_window_id', $_GET['id1'], PDO::PARAM_INT);
    $stmt->bindParam(':p_session_id', $_GET['id2'], PDO::PARAM_INT);
    $stmt->execute();

    $result = $stmt->fetch(PDO::FETCH_ASSOC);  // Assuming you want an associative array

    if ($result) {
        // Decode the JSON string into a PHP array
        $data = json_decode($result['jsontxt'], true);

        // Access the 'data' array
        $menuItems = $data['data']['tabs'];
        
        // Function to recursively traverse the menu items and extract data
            $html = '
                    <!DOCTYPE html>
                    <html lang="en">
                    <head>
                      <meta charset="UTF-8">
                      <meta name="viewport" content="width=device-width, initial-scale=1.0">
                      <title>Socio de Negocio</title>
                      <style>
                        /* Global Styles */
                        * {
                          margin: 0;
                          padding: 0;
                          box-sizing: border-box;
                        }
                    
                        body {
                          font-family: Arial, sans-serif;
                          display: flex;
                          flex-direction: column;
                          height: auto;
                        }
                    
                        /* Navbar */
                        .navbar {
                          position: fixed;
                          background-color: #007BFF;
                          color: white;
                          text-align: center;
      width: calc(100vw - 20px); /* 100% del ancho de la ventana menos el ancho del sidebar */
                        }
                    
                        /* Main Layout */
                        .main {
                          display: flex;
                          flex: 1;
                          overflow: hidden;
      width: calc(100vw - 20px); /* 100% del ancho de la ventana menos el ancho del sidebar */
      margin-top: 70px; /* Espacio para el navbar */
      position: fixed;
                        }
                    
                        /* Sidebar */
                        .sidebar {
                          width: 200px;
                          background-color: #f8f9fa;
                          border-right: 1px solid #ddd;
                          overflow-y: auto;
                          padding: 10px;
                          height: calc(100vh - 140px);
                        }
                    
                        .sidebar .tab {
                          margin-bottom: 10px;
                        }
                    
                        .sidebar .tab input[type="checkbox"] {
                          display: none;
                        }
                    
                        .sidebar .tab-label {
                          display: block;
                          background-color: #007BFF;
                          color: white;
                          padding: 10px;
                          border-radius: 5px;
                          cursor: pointer;
                          margin-bottom: 5px;
                        }
                    
                        .sidebar .tab-label:hover {
                          background-color: #0056b3;
                        }
                    
                        .sidebar .tab-content {
                          display: none;
                          padding-left: 10px;
                        }
                    
                        .sidebar .tab input[type="checkbox"]:checked + .tab-label + .tab-content {
                          display: block;
                        }
                    
                        /* Content Area */
                        .content {
                          flex: 1;
                          display: flex;
                          flex-direction: column;
                          overflow: hidden;
                        }
                    
                        /* Tools Navbar */
                        .tools-navbar {
                          background-color: #343a40;
                          color: white;
                          display: flex;
                          padding: 10px;
                          gap: 10px;
                          align-items: center;
                          flex-wrap: wrap;
                        }
                    
                        .tools-navbar button {
                          background-color: #007BFF;
                          color: white;
                          border: none;
                          padding: 5px 10px;
                          cursor: pointer;
                          border-radius: 5px;
                          margin-bottom: 5px;
                        }
                    
                        .tools-navbar button:disabled {
                          background-color: #6c757d;
                          cursor: not-allowed;
                        }
                    
                        .tools-navbar button:hover:not(:disabled) {
                          background-color: #0056b3;
                        }
                    
                        /* Table with Pagination */
                        .table-container {
                          flex: 1;
                          overflow-y: auto;
                          padding: 10px;
                        }
                    
                        table {
                          width: 100%;
                          border-collapse: collapse;
                        }
                    
                        table th, table td {
                          border: 1px solid #ddd;
                          padding: 8px;
                          text-align: left;
                        }
                    
                        table th {
                          background-color: #007BFF;
                          color: white;
                        }
                    
                        .pagination {
                          display: flex;
                          justify-content: center;
                          padding: 10px 0;
                        }
                    
                        .pagination button {
                          background-color: #007BFF;
                          color: white;
                          border: none;
                          padding: 5px 10px;
                          margin: 0 5px;
                          cursor: pointer;
                          border-radius: 5px;
                        }
                    
                        .pagination button:disabled {
                          background-color: #6c757d;
                          cursor: not-allowed;
                        }
                    
                        .pagination button:hover:not(:disabled) {
                          background-color: #0056b3;
                        }
                    
                        /* RESPONSIVE DESIGN */
                        @media (max-width: 768px) {
                          .main {
                            flex-direction: column;
                          }
                    
                          .sidebar {
                            width: 100%;
                            order: 2;
                          }
                    
                          .content {
                            order: 1;
                          }
                    
                          .tools-navbar {
                            flex-wrap: wrap;
                            justify-content: center;
                          }
                    
                          .table-container {
                            padding: 5px;
                          }
                    
                          table th, table td {
                            font-size: 12px;
                          }
                    
                          .pagination button {
                            padding: 5px;
                            font-size: 12px;
                          }
                        }
                    
                        @media (max-width: 480px) {
                          .tools-navbar {
                            gap: 5px;
                          }
                    
                          table th, table td {
                            font-size: 10px;
                            padding: 5px;
                          }
                        }
                      </style>
                    </head>
                    <body>
                      <!-- Navbar -->
                      <div class="navbar">
                          <!-- Tools Navbar -->
                          <div class="tools-navbar">
                            <button disabled>Deshacer</button>
                            <button>Crear</button>
                            <button disabled>Modificar</button>
                            <button disabled>Eliminar</button>
                            <button disabled>Imprimir</button>
                            <button>Buscar</button>
                            <button>Filtrar</button>
                          </div>
                          
                      </div>

                      <!-- Main Layout -->
                      <div class="main">
                    
                        <!-- Content Area -->
                        <div class="content">
                          <!-- Table with Pagination -->
                          <div class="table-container">
                            <table>
                              <thead>
                                <tr>
                                  <th>#</th>
                                  <th>Nombre</th>
                                  <th>Estado</th>
                                </tr>
                              </thead>
                              <tbody>
                                <tr>
                                  <td>1</td>
                                  <td>Registro 1</td>
                                  <td>Activo</td>
                                </tr>
                                <tr>
                                  <td>2</td>
                                  <td>Registro 2</td>
                                  <td>Inactivo</td>
                                </tr>
                                <tr>
                                  <td>3</td>
                                  <td>Registro 3</td>
                                  <td>Pendiente</td>
                                </tr>
                              </tbody>
                            </table>
                    
                            <!-- Pagination -->
                            <div class="pagination">
                              <button disabled>&laquo; Anterior</button>
                              <button>Siguiente &raquo;</button>
                            </div>
                          </div>
                        </div>';
                        
            $html .= '   <!-- Sidebar -->
                        <div class="sidebar">';
            foreach ($menuItems as $item1) {
                    $html .= '<div id="' . $item1['code'] . '_tab1" class="tab">
                                <label for="' . $item1['code'] . '_label1" class="tab-label">' . $item1['name'] . ' (' . $item1['code'] . ')</label>
                                <input type="checkbox" id="' . $item1['code'] . '_label1">';
                    $html .= '<a id="' . $item1['code'] . '_atab1" onclick="getTab(' . $item1['code'] . ')>' . $item1['name'] . '</a>';
                    if (isset($item1['subtabs']) && !empty($item1['subtabs'])) {
                        $html .= '<div id="' . $item1['code'] . '_content1" class="tab-content">';
                        foreach ($item1['subtabs'] as $item2) {
                            $html .= '<label for="' . $item2['code'] . '_label2" class="tab-label">' . $item2['name'] . ' (' . $item2['code'] . ')</label>
                                        <input type="checkbox" id="' . $item2['code'] . '_label2">';
                            $html .= '<a id="' . $item2['code'] . '_atab2" onclick="getTab(' . $item2['code'] . ')">' . $item2['name'] . '</a>';
                            if (isset($item2['subtabs']) && !empty($item2['subtabs'])) {
                                $html .= '<div id="' . $item2['code'] . '_content2" class="tab-content">';
                                foreach ($item2['subtabs'] as $item3) {
                                    $html .= '<label for="' . $item3['code'] . '_label3" class="tab-label">' . $item3['name'] . ' (' . $item3['code'] . ')</label>
                                                <input type="checkbox" id="' . $item3['code'] . '_label3">';
                                    $html .= '<a id="' . $item3['code'] . '_atab3" onclick="getTab(' . $item3['code'] . ')">' . $item3['name'] . '</a>';
                                    if (isset($item3['subtabs']) && !empty($item3['subtabs'])) {
                                        $html .= '<div id="' . $item3['code'] . '_content3" class="tab-content">';
                                        foreach ($item3['subtabs'] as $item4) {
                                            $html .= '<label for="' . $item4['code'] . '_label4" class="tab-label">' . $item4['name'] . ' (' . $item4['code'] . ')</label>
                                                        <input type="checkbox" id="' . $item4['code'] . '_label4">';
                                            $html .= '<a id="' . $item4['code'] . '_atab4" onclick="getTab(' . $item4['code'] . ')">' . $item4['name'] . '</a>';
                                            if (isset($item4['subtabs']) && !empty($item4['subtabs'])) {
                                                $html .= '<div id="' . $item4['code'] . '_content4" class="tab-content">';
                                                foreach ($item4['subtabs'] as $item5) {
                                                    $html .= '<label for="' . $item5['code'] . '_label5" class="tab-label">' . $item5['name'] . ' (' . $item5['code'] . ')</label>
                                                                <input type="checkbox" id="' . $item5['code'] . '_label5">';
                                                    $html .= '<a id="' . $item5['code'] . '_atab5" onclick="getTab(' . $item5['code'] . ')">' . $item5['name'] . ' (' . $item5['code'] . ')</a>';
                                                }
                                                $html .=  '</div>';
                                            } else {
                                                $html .= '<a id="' . $item4['code'] . '_atab4" onclick="getTab(' . $item4['code'] . ')">' . $item4['name'] . '</a>';
                                            }
                                        }
                                        
                                        $html .=  '</div>';
                                    } else {
                                        $html .= '<a id="' . $item3['code'] . '_atab3" onclick="getTab(' . $item3['code'] . ')">' . $item3['name'] . '</a>';
                                    }
                                }
                                $html .=  '</div>';
                            } else {
                                $html .= '<a id="' . $item2['code'] . '_atab2" onclick="getTab(' . $item2['code'] . ')">' . $item2['name'] . '</a>';
                            }
                        }
                        $html .=  '</div>';
                    } else {
                        $html .= '<a id="' . $item1['code'] . '_atab1" onclick="getTab(' . $item1['code'] . ')>' . $item1['name'] . '</a>';
                        $html .=  '</div>';
                    }
            }

                $html .=  '
                          <div class="tab">
                            <input type="checkbox" id="tab1">
                            <label class="tab-label" for="tab1">Pestaña 1</label>
                            <div class="tab-content">
                              <p>Contenido de la Pestaña 1</p>
                              <div class="tab">
                                <input type="checkbox" id="subtab1">
                                <label class="tab-label" for="subtab1">Subpestaña 1.1</label>
                                <div class="tab-content">
                                  <p>Contenido de la Subpestaña 1.1</p>
                                </div>
                              </div>
                            </div>
                          </div>
                          
                          <div class="tab">
                            <input type="checkbox" id="tab2">
                            <label class="tab-label" for="tab2">Pestaña 2</label>
                            <div class="tab-content">
                              <p>Contenido de la Pestaña 2</p>
                            </div>
                          </div>
                        </div>
                        
                        
                      </div>
                    </body>
                    </html>';
            header('Content-Type: application/text');
            echo $html;
    } else {
        $response = ["data" => [
                    "code" => 401,
                    "message"=> "Credenciales inválidas (api_getWindow)"
                ]];
    }
    // Enviar la respuesta como JSON
/***********
    header('Content-Type: application/json');
    echo json_encode($response);
************/
} catch (PDOException $e) {
    // Manejo de errores
    echo json_encode(['error' => 'Error de conexion a la base de datos (apicore_getmenu)']);
    error_log("Error de conexion: (api_getWindow)" . $e->getMessage());
}
?>
