<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CRUD Dinámico con Paginación y Modal</title>
    <style>
        /* Estilos generales */
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            box-sizing: border-box;
        }
        h2 {
            text-align: center;
        }
        .container {
            max-width: 1200px;
            margin: auto;
            overflow-x: auto;
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 10px;
            text-align: center;
        }
        thead {
            background-color: #007BFF;
            color: white;
        }
        .pagination {
            display: flex;
            justify-content: center;
            margin: 10px 0;
            gap: 5px;
        }
        .pagination button {
            padding: 8px 12px;
            border: none;
            cursor: pointer;
            background-color: #007BFF;
            color: white;
        }
        .pagination button.disabled {
            background-color: #ccc;
            cursor: not-allowed;
        }
        .action-btn {
            padding: 5px 10px;
            margin: 2px;
            border: none;
            cursor: pointer;
            color: white;
            border-radius: 3px;
        }
        .edit-btn {
            background-color: #ffc107;
        }
        .delete-btn {
            background-color: #dc3545;
        }
        .new-btn {
            padding: 10px;
            margin-bottom: 10px;
            background-color: #28a745;
            color: white;
            border: none;
            cursor: pointer;
        }

        /* Estilos del Modal */
        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            justify-content: center;
            align-items: center;
        }
        .modal-content {
            background-color: white;
            padding: 20px;
            border-radius: 5px;
            width: 90%;
            max-width: 500px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.3);
        }
        .modal-content h3 {
            margin-top: 0;
        }
        .modal-content form {
            display: flex;
            flex-wrap: wrap;
            gap: 10px;
        }
        .modal-content form input {
            flex: 1 1 calc(50% - 10px);
            padding: 8px;
            box-sizing: border-box;
        }
        .modal-content button {
            margin-top: 10px;
            padding: 10px;
            border: none;
            cursor: pointer;
        }
        .close-btn {
            background-color: #dc3545;
            color: white;
        }
        .save-btn {
            background-color: #28a745;
            color: white;
        }
    </style>
</head>
<body>
    <h2>CRUD Dinámico con Modal</h2>
    <div class="container">
        <!-- Botón para nuevo registro -->
        <button class="new-btn" onclick="showFormModal()">Nuevo Registro</button>

        <!-- Tabla dinámica -->
        <table>
            <thead id="tableHead"></thead>
            <tbody id="tableBody"></tbody>
        </table>

        <!-- Paginación -->
        <div class="pagination" id="pagination"></div>
    </div>

    <!-- Modal de formulario -->
    <div class="modal" id="formModal">
        <div class="modal-content">
            <h3 id="formTitle">Nuevo Registro</h3>
            <form id="dynamicForm"></form>
            <button class="save-btn" onclick="saveForm()">Guardar</button>
            <button class="close-btn" onclick="closeFormModal()">Cerrar</button>
        </div>
    </div>

    <script>
        const jsonData = [];
        for (let i = 1; i <= 50; i++) {
            jsonData.push({
                "Account": "Account " + i,
                "Amount": (Math.random() * 1000).toFixed(4),
                "Date": "06/19/2024",
                "Yes-No": i % 2 === 0 ? "Yes" : "No",
                "String": "Example " + i
            });
        }

        const tableHead = document.getElementById("tableHead");
        const tableBody = document.getElementById("tableBody");
        const paginationDiv = document.getElementById("pagination");
        const formModal = document.getElementById("formModal");
        const dynamicForm = document.getElementById("dynamicForm");
        const formTitle = document.getElementById("formTitle");

        let currentPage = 1;
        const rowsPerPage = 10;
        let editRow = null;

        // Construir tabla
        function buildTable() {
            const keys = Object.keys(jsonData[0]);
            tableHead.innerHTML = "<tr>" + keys.map(key => `<th>${key}</th>`).join('') + "<th>Acciones</th></tr>";
            renderTableRows();
            setupPagination();
        }

        function renderTableRows() {
            tableBody.innerHTML = '';
            const start = (currentPage - 1) * rowsPerPage;
            const end = start + rowsPerPage;
            const paginatedData = jsonData.slice(start, end);

            paginatedData.forEach((row, index) => {
                const rowHTML = Object.values(row).map(value => `<td>${value}</td>`).join('');
                tableBody.innerHTML += `
                    <tr>
                        ${rowHTML}
                        <td>
                            <button class="action-btn edit-btn" onclick="editRowData(${start + index})">Editar</button>
                            <button class="action-btn delete-btn" onclick="deleteRow(${start + index})">Eliminar</button>
                        </td>
                    </tr>
                `;
            });
        }

        function setupPagination() {
            const totalPages = Math.ceil(jsonData.length / rowsPerPage);
            paginationDiv.innerHTML = `
                <button onclick="changePage(${currentPage - 1})" ${currentPage === 1 ? 'disabled' : ''}>Anterior</button>
                ${Array.from({ length: totalPages }, (_, i) => `
                    <button onclick="changePage(${i + 1})" ${i + 1 === currentPage ? 'disabled' : ''}>${i + 1}</button>
                `).join('')}
                <button onclick="changePage(${currentPage + 1})" ${currentPage === totalPages ? 'disabled' : ''}>Siguiente</button>
            `;
        }

        function changePage(page) {
            const totalPages = Math.ceil(jsonData.length / rowsPerPage);
            if (page >= 1 && page <= totalPages) {
                currentPage = page;
                renderTableRows();
                setupPagination();
            }
        }

        function showFormModal(edit = false) {
            formModal.style.display = "flex";
            dynamicForm.innerHTML = Object.keys(jsonData[0]).map(key => `
                <input type="text" id="input_${key}" placeholder="${key}">
            `).join('');
            formTitle.innerText = edit ? "Editar Registro" : "Nuevo Registro";
        }

        function closeFormModal() {
            formModal.style.display = "none";
            editRow = null;
        }

        function saveForm() {
            const newData = {};
            Object.keys(jsonData[0]).forEach(key => {
                newData[key] = document.getElementById(`input_${key}`).value;
            });

            if (editRow !== null) {
                jsonData[editRow] = newData;
            } else {
                jsonData.push(newData);
            }

            closeFormModal();
            renderTableRows();
            setupPagination();
        }

        function editRowData(index) {
            editRow = index;
            showFormModal(true);
            const row = jsonData[index];
            Object.keys(row).forEach(key => {
                document.getElementById(`input_${key}`).value = row[key];
            });
        }

        function deleteRow(index) {
            jsonData.splice(index, 1);
            renderTableRows();
            setupPagination();
        }

        buildTable();
    </script>
</body>
</html>
