<?php
// api.php
// https://apis.kontroles.com/auth/api_role.php?p_session_id=1012517

require '../headers.php';
require '../authdb.php';


try {
    // Crear una conexion con PDO
    $dsn = "pgsql:host=" . DB_HOST . ";dbname=" . DB_NAME;
    $pdo = new PDO($dsn, DB_USER, DB_PASS, [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]);
    $stmt = $pdo->prepare("SELECT apicore_getgriddata AS jsontxt FROM logic.apicore_getgriddata(:p_session_id::integer, :p_tab_id::integer, :p_record_id::integer, :p_offset::integer, :p_limit::integer, :p_search::text)");

    if ($_GET['id3'] === '0') {
        $id3 = null;
    } else {
        $id3 = $_GET['id3'];
    }
    $prm6 = '{}';

    // Bind parameters securely
    $stmt->bindParam(':p_session_id',   $_GET['id2'], PDO::PARAM_INT);
    $stmt->bindParam(':p_tab_id',       $_GET['id1'], PDO::PARAM_INT);
    $stmt->bindParam(':p_record_id',    $id3, PDO::PARAM_INT);
    $stmt->bindParam(':p_offset',       $_GET['id4'], PDO::PARAM_INT);
    $stmt->bindParam(':p_limit',        $_GET['id5'], PDO::PARAM_INT);
    $stmt->bindParam(":p_search",       $prm6, PDO::PARAM_STR);
    $stmt->execute();

    $result = $stmt->fetch(PDO::FETCH_ASSOC);  // Assuming you want an associative array

    if ($result) {
        // Decode the JSON string into a PHP array
        $data = json_decode($result['jsontxt'], true);

        // Access the 'data' array
        $headersInfo = $data['headers'];
        $contentsItems = $data['contents'];
        
        // Function to recursively traverse the menu items and extract data
            $html = '
                    <!DOCTYPE html>
                    <html lang="es">
                    <head>
                        <meta charset="UTF-8">
                        <meta name="viewport" content="width=device-width, initial-scale=1.0">
                        <title>CRUD - Grid</title>
                        <style>
                            /* Estilos generales * /
                            body {
                                font-family: Arial, sans-serif;
                                margin: 0;
                                padding: 20px;
                                box-sizing: border-box;
                            }
                            h2 {
                                text-align: center;
                            }
                            .container {
                                max-width: 1200px;
                                margin: auto;
                                overflow-x: auto;
                            }
                            table {
                                width: 100%;
                                border-collapse: collapse;
                            }
                            th, td {
                                border: 1px solid #ddd;
                                padding: 10px;
                                text-align: center;
                            }
                            thead {
                                background-color: #007BFF;
                                color: white;
                            }
                            .pagination {
                                display: flex;
                                justify-content: center;
                                margin: 10px 0;
                                gap: 5px;
                            }
                            .pagination button {
                                padding: 8px 12px;
                                border: none;
                                cursor: pointer;
                                background-color: #007BFF;
                                color: white;
                            }
                            .pagination button.disabled {
                                background-color: #ccc;
                                cursor: not-allowed;
                            }
                            .action-btn {
                                padding: 5px 10px;
                                margin: 2px;
                                border: none;
                                cursor: pointer;
                                color: white;
                                border-radius: 3px;
                            }
                            .edit-btn {
                                background-color: #ffc107;
                            }
                            .delete-btn {
                                background-color: #dc3545;
                            }
                            .new-btn {
                                padding: 10px;
                                margin-bottom: 10px;
                                background-color: #28a745;
                                color: white;
                                border: none;
                                cursor: pointer;
                            }
                    
                            /* Estilos del Modal * /
                            .modal {
                                display: none;
                                position: fixed;
                                top: 0;
                                left: 0;
                                width: 100%;
                                height: 100%;
                                background-color: rgba(0, 0, 0, 0.5);
                                justify-content: center;
                                align-items: center;
                            }
                            .modal-content {
                                background-color: white;
                                padding: 20px;
                                border-radius: 5px;
                                width: 90%;
                                max-width: 500px;
                                box-shadow: 0 0 10px rgba(0, 0, 0, 0.3);
                            }
                            .modal-content h3 {
                                margin-top: 0;
                            }
                            .modal-content form {
                                display: flex;
                                flex-wrap: wrap;
                                gap: 10px;
                            }
                            .modal-content form input {
                                flex: 1 1 calc(50% - 10px);
                                padding: 8px;
                                box-sizing: border-box;
                            }
                            .modal-content button {
                                margin-top: 10px;
                                padding: 10px;
                                border: none;
                                cursor: pointer;
                            }
                            .close-btn {
                                background-color: #dc3545;
                                color: white;
                            }
                            .save-btn {
                                background-color: #28a745;
                                color: white;
                            }
                        </style>
                    </head>
                    <body>
                        <div class="container">
                        <h3>Pestaña: ' . $data['code'] . '</h3>
                        
                        <!-- Modal de formulario -->
                        <div style = "display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background-color: rgba(0, 0, 0, 0.5); justify-content: center; align-items: center;" id="formModal">
                            <div style = " background-color: white; padding: 20px; border-radius: 5px; width: 90%; max-width: 500px; box-shadow: 0 0 10px rgba(0, 0, 0, 0.3);" class="modal-content">
                                <h3 id="formTitle">Nuevo Registro</h3>
                                <form id="dynamicForm"></form>
                                <button style="background-color: #28a745; color: white;" class="save-btn" onclick="saveForm()">Guardar</button>
                                <button style="background-color: #dc3545; color: white;" class="close-btn" onclick="closeFormModal()">Cerrar</button>
                            </div>
                        </div>
                        
                        
                            <!-- Botón para nuevo registro -->
                            <button style="padding: 10px; margin-bottom: 10px; background-color: #28a745; color: white; border: none; cursor: pointer;" onclick="showFormModal()">Nuevo Registro</button>
                    
<table style="width: 100%; border-collapse: collapse;">
            <thead style="background-color: #007BFF; color: white;" id="tableHead">
                <tr>
                    <th style="border: 1px solid #ddd; padding: 10px; text-align: center;">Account</th>
                    <th style="border: 1px solid #ddd; padding: 10px; text-align: center;">Amount</th>
                    <th style="border: 1px solid #ddd; padding: 10px; text-align: center;">Date</th>
                    <th style="border: 1px solid #ddd; padding: 10px; text-align: center;">Yes-No</th>
                    <th style="border: 1px solid #ddd; padding: 10px; text-align: center;">String</th>
                    <th style="border: 1px solid #ddd; padding: 10px; text-align: center;">Acciones</th>
                </tr>
            </thead>
            <tbody id="tableBody">
                    <tr>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">Account 1</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">730.2038</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">06/19/2024</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">No</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">Example 1</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">
                            <button style="padding: 5px 10px; margin: 2px; border: none; cursor: pointer; color: white; border-radius: 3px; background-color: #ffc107;" onclick="editRowData(0)">Editar</button>
                            <button style="padding: 5px 10px; margin: 2px; border: none; cursor: pointer; color: white; border-radius: 3px; background-color: #dc3545;" onclick="deleteRow(0)">Eliminar</button>
                        </td>
                    </tr>
                
                    <tr>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">Account 2</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">830.3423</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">06/19/2024</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">Yes</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">Example 2</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">
                            <button style="padding: 5px 10px; margin: 2px; border: none; cursor: pointer; color: white; border-radius: 3px; background-color: #ffc107;" onclick="editRowData(1)">Editar</button>
                            <button style="padding: 5px 10px; margin: 2px; border: none; cursor: pointer; color: white; border-radius: 3px; background-color: #dc3545;" onclick="deleteRow(1)">Eliminar</button>
                        </td>
                    </tr>
                
                    <tr>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">Account 3</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">479.9000</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">06/19/2024</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">No</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">Example 3</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">
                            <button style="padding: 5px 10px; margin: 2px; border: none; cursor: pointer; color: white; border-radius: 3px; background-color: #ffc107;" onclick="editRowData(2)">Editar</button>
                            <button style="padding: 5px 10px; margin: 2px; border: none; cursor: pointer; color: white; border-radius: 3px; background-color: #dc3545;" onclick="deleteRow(2)">Eliminar</button>
                        </td>
                    </tr>
                
                    <tr>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">Account 4</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">962.5090</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">06/19/2024</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">Yes</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">Example 4</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">
                            <button style="padding: 5px 10px; margin: 2px; border: none; cursor: pointer; color: white; border-radius: 3px; background-color: #ffc107;" onclick="editRowData(3)">Editar</button>
                            <button style="padding: 5px 10px; margin: 2px; border: none; cursor: pointer; color: white; border-radius: 3px; background-color: #dc3545;" onclick="deleteRow(3)">Eliminar</button>
                        </td>
                    </tr>
                
                    <tr>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">Account 5</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">73.2822</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">06/19/2024</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">No</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">Example 5</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">
                            <button style="padding: 5px 10px; margin: 2px; border: none; cursor: pointer; color: white; border-radius: 3px; background-color: #ffc107;" onclick="editRowData(4)">Editar</button>
                            <button style="padding: 5px 10px; margin: 2px; border: none; cursor: pointer; color: white; border-radius: 3px; background-color: #dc3545;" onclick="deleteRow(4)">Eliminar</button>
                        </td>
                    </tr>
                
                    <tr>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">Account 6</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">627.1502</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">06/19/2024</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">Yes</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">Example 6</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">
                            <button style="padding: 5px 10px; margin: 2px; border: none; cursor: pointer; color: white; border-radius: 3px; background-color: #ffc107;" onclick="editRowData(5)">Editar</button>
                            <button style="padding: 5px 10px; margin: 2px; border: none; cursor: pointer; color: white; border-radius: 3px; background-color: #dc3545;" onclick="deleteRow(5)">Eliminar</button>
                        </td>
                    </tr>
                
                    <tr>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">Account 7</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">492.9120</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">06/19/2024</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">No</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">Example 7</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">
                            <button style="padding: 5px 10px; margin: 2px; border: none; cursor: pointer; color: white; border-radius: 3px; background-color: #ffc107;" onclick="editRowData(6)">Editar</button>
                            <button style="padding: 5px 10px; margin: 2px; border: none; cursor: pointer; color: white; border-radius: 3px; background-color: #dc3545;" onclick="deleteRow(6)">Eliminar</button>
                        </td>
                    </tr>
                
                    <tr>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">Account 8</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">672.4192</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">06/19/2024</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">Yes</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">Example 8</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">
                            <button style="padding: 5px 10px; margin: 2px; border: none; cursor: pointer; color: white; border-radius: 3px; background-color: #ffc107;" onclick="editRowData(7)">Editar</button>
                            <button style="padding: 5px 10px; margin: 2px; border: none; cursor: pointer; color: white; border-radius: 3px; background-color: #dc3545;" onclick="deleteRow(7)">Eliminar</button>
                        </td>
                    </tr>
                
                    <tr>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">Account 9</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">541.2804</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">06/19/2024</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">No</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">Example 9</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">
                            <button style="padding: 5px 10px; margin: 2px; border: none; cursor: pointer; color: white; border-radius: 3px; background-color: #ffc107;" onclick="editRowData(8)">Editar</button>
                            <button style="padding: 5px 10px; margin: 2px; border: none; cursor: pointer; color: white; border-radius: 3px; background-color: #dc3545;" onclick="deleteRow(8)">Eliminar</button>
                        </td>
                    </tr>
                
                    <tr>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">Account 10</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">791.6063</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">06/19/2024</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">Yes</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">Example 10</td>
                        <td style="border: 1px solid #ddd; padding: 10px; text-align: center;">
                            <button style="padding: 5px 10px; margin: 2px; border: none; cursor: pointer; color: white; border-radius: 3px; background-color: #ffc107;" onclick="editRowData(9)">Editar</button>
                            <button style="padding: 5px 10px; margin: 2px; border: none; cursor: pointer; color: white; border-radius: 3px; background-color: #dc3545;" onclick="deleteRow(9)">Eliminar</button>
                        </td>
                    </tr>
                </tbody>
        </table>                            
                            
                            
                            
                            
                    
                            <!-- Paginación -->
                            <div class="pagination" id="pagination"></div>
                        </div>
                    
                        <script>
                            const jsonData = [];
                            for (let i = 1; i <= 50; i++) {
                                jsonData.push({
                                    "Account": "Account " + i,
                                    "Amount": (Math.random() * 1000).toFixed(4),
                                    "Date": "06/19/2024",
                                    "Yes-No": i % 2 === 0 ? "Yes" : "No",
                                    "String": "Example " + i
                                });
                            }
                    
                            const tableHead = document.getElementById("tableHead");
                            const tableBody = document.getElementById("tableBody");
                            const paginationDiv = document.getElementById("pagination");
                            const formModal = document.getElementById("formModal");
                            const dynamicForm = document.getElementById("dynamicForm");
                            const formTitle = document.getElementById("formTitle");
                    
                            let currentPage = 1;
                            const rowsPerPage = 10;
                            let editRow = null;
                    
                            // Construir tabla
                            function buildTable() {
                                const keys = Object.keys(jsonData[0]);
                                tableHead.innerHTML = "<tr>" + keys.map(key => `<th>${key}</th>`).join("") + "<th>Acciones</th></tr>";
                                renderTableRows();
                                setupPagination();
                            }
                    
                            function renderTableRows() {
                                tableBody.innerHTML = "";
                                const start = (currentPage - 1) * rowsPerPage;
                                const end = start + rowsPerPage;
                                const paginatedData = jsonData.slice(start, end);
                    
                                paginatedData.forEach((row, index) => {
                                    const rowHTML = Object.values(row).map(value => `<td>${value}</td>`).join("");
                                    tableBody.innerHTML += `
                                        <tr>
                                            ${rowHTML}
                                            <td>
                                                <button class="action-btn edit-btn" onclick="editRowData(${start + index})">Editar</button>
                                                <button class="action-btn delete-btn" onclick="deleteRow(${start + index})">Eliminar</button>
                                            </td>
                                        </tr>
                                    `;
                                });
                            }
                    
                            function setupPagination() {
                                const totalPages = Math.ceil(jsonData.length / rowsPerPage);
                                paginationDiv.innerHTML = `
                                    <button onclick="changePage(${currentPage - 1})" ${currentPage === 1 ? "disabled" : ""}>Anterior</button>
                                    ${Array.from({ length: totalPages }, (_, i) => `
                                        <button onclick="changePage(${i + 1})" ${i + 1 === currentPage ? "disabled" : ""}>${i + 1}</button>
                                    `).join("")}
                                    <button onclick="changePage(${currentPage + 1})" ${currentPage === totalPages ? "disabled" : ""}>Siguiente</button>
                                `;
                            }
                    
                            function changePage(page) {
                                const totalPages = Math.ceil(jsonData.length / rowsPerPage);
                                if (page >= 1 && page <= totalPages) {
                                    currentPage = page;
                                    renderTableRows();
                                    setupPagination();
                                }
                            }
                    
                            function showFormModal(edit = false) {
                                formModal.style.display = "flex";
                                dynamicForm.innerHTML = Object.keys(jsonData[0]).map(key => `
                                    <input type="text" id="input_${key}" placeholder="${key}">
                                `).join("");
                                formTitle.innerText = edit ? "Editar Registro" : "Nuevo Registro";
                            }
                    
                            function closeFormModal() {
                                formModal.style.display = "none";
                                editRow = null;
                            }
                    
                            function saveForm() {
                                const newData = {};
                                Object.keys(jsonData[0]).forEach(key => {
                                    newData[key] = document.getElementById(`input_${key}`).value;
                                });
                    
                                if (editRow !== null) {
                                    jsonData[editRow] = newData;
                                } else {
                                    jsonData.push(newData);
                                }
                    
                                closeFormModal();
//                                renderTableRows();
                                setupPagination();
                            }
                    
                            function editRowData(index) {
                                editRow = index;
                                showFormModal(true);
                                const row = jsonData[index];
                                Object.keys(row).forEach(key => {
                                    document.getElementById(`input_${key}`).value = row[key];
                                });
                            }
                    
                            function deleteRow(index) {
                                jsonData.splice(index, 1);
//                                renderTableRows();
                                setupPagination();
                            }
                    
//                            buildTable();
                        </script>
                    </body>
                    </html>
                    ';
            header('Content-Type: application/text');
            echo $html;
    } else {
        $response = ["data" => [
                    "code" => 401,
                    "message"=> "Credenciales inválidas (api_getTab)"
                ]];
    }
    // Enviar la respuesta como JSON
/***********
    header('Content-Type: application/json');
    echo json_encode($response);
************/
} catch (PDOException $e) {
    // Manejo de errores
    echo json_encode(['error' => 'Error de conexion a la base de datos (api_getTab)']);
    error_log("Error de conexion: (api_getTab)" . $e->getMessage());
}
?>
