<?php
// api.php
// https://apis.kontroles.com/auth/api_role.php?p_session_id=1012517

require '../headers.php';
require '../authdb.php';

try {
    // Crear una conexion con PDO
    $dsn = "pgsql:host=" . DB_HOST . ";dbname=" . DB_NAME;
    $pdo = new PDO($dsn, DB_USER, DB_PASS, [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]);
    $stmt = $pdo->prepare("SELECT apicore_getwindowbyid AS jsontxt FROM logic.apicore_getwindowbyid(:p_window_id::integer, :p_session_id::integer)");

    // Bind parameters securely
    $stmt->bindParam(':p_window_id', $_GET['id1'], PDO::PARAM_INT);
    $stmt->bindParam(':p_session_id', $_GET['id2'], PDO::PARAM_INT);
    $stmt->execute();

    $result = $stmt->fetch(PDO::FETCH_ASSOC);  // Assuming you want an associative array

    if ($result) {
        // Decode the JSON string into a PHP array
        $data = json_decode($result['jsontxt'], true);

        // Access the 'data' array
        $windowInfo = $data['data'];
        $menuItems = $data['data']['tabs'];
        
        // Function to recursively traverse the menu items and extract data
            $html = '
                    <!DOCTYPE html>
                    <html lang="en">
                    <head>
                      <meta charset="UTF-8">
                      <meta name="viewport" content="width=device-width, initial-scale=1.0">
                      <title>' . $windowInfo['name'] . '</title>
                      <style>
                        /* Global Styles */
                        * {
                          margin: 0;
                          padding: 0;
                          box-sizing: border-box;
                        }
                    
                        body {
                          font-family: Arial, sans-serif;
                          display: flex;
                          flex-direction: column;
                          height: auto;
                          min-height: 100vh;
                        }
                    
                        /* Navbar */
                        .navbar {
                          position: fixed;
                          background-color: #007BFF;
                          color: white;
                          text-align: center;
      width: calc(100vw - 20px); /* 100% del ancho de la ventana menos el ancho del sidebar */
                        }
                    
                        /* Main Layout */
                        .main {
                          display: flex;
                          flex: 1;
                          overflow: hidden;
      width: calc(100vw - 20px); /* 100% del ancho de la ventana menos el ancho del sidebar */
      margin-top: 70px; /* Espacio para el navbar */
      position: fixed;
                        }
                    
    /* Sidebar base */
    .sidebar {
      width: 228px;
      height: 100vh;
      background-color: white;
      color: white;
      position: fixed;
      top: 60px; /* Ajusta debajo del navbar */
      right: 0px; /* Oculta la sidebar por defecto */
      padding: 10px;
      overflow-y: auto; 
      box-shadow: 3px 0 5px rgba(0, 0, 0, 0.2);
      transition: all 0.3s ease;
      z-index: 999;
    }
    
    .no-scrollbar {
      -ms-overflow-style: none; /* IE and Edge */
      scrollbar-width: none; /* Firefox */
    }
    
    .no-scrollbar::-webkit-scrollbar {
      display: none; /* Chrome, Safari and Opera */
    }

    .menu-toggle input:checked ~ .sidebar {
      left: 0; /* Muestra la sidebar */
    }

    .sidebar h2 {
      text-align: center;
      margin-bottom: 20px;
    }

    .sidebar ul {
      padding: 0;
      margin: 0;
      display: block;
      list-style-type: none;
    }

    .sidebar ul li {
      margin: 0;
      display: list-item;
    }

    .sidebar ul li a,
    .sidebar ul li label {
      display: block;
      text-decoration: none;
      color: white;
      padding: 10px;
      background-color: #3b5998;
      border-radius: 5px;
      cursor: pointer;
    }

    .sidebar ul li a:hover,
    .sidebar ul li label:hover {
      background-color: #5d82c6;
    }

    .sidebar ul li ul {
      display: list-item;
      padding-left: 0px;
      padding-right: 20px;
    }

    .sidebar ul li input[type="checkbox"] {
      display: none;
    }

    .sidebar ul li input[type="checkbox"]:checked + ul {
      display: list-item;
    }

    .sidebar ul li ul li a {
      background-color: #1abc9c;
    }

    .sidebar ul li ul li a:hover {
      background-color: #16a085;
    }


                        /* Content Area 
                        .content {
                          flex: 1;
                          display: flex;
                          flex-direction: column;
                          overflow: hidden;
                        }   */
/* Contenido principal */
.content {
      width: calc(100vw - 228px); /* 100% del ancho de la ventana menos el ancho del sidebar */
      height: calc(100vh - 70px); /* 100% del alto de la ventana menos la altura del navbar */
      margin-top: 0px; /* Espacio para el navbar */
      margin-left: 0px; /* Espacio para el sidebar */
      padding: 5px; /* Añadir un poco de padding al contenido */
      box-sizing: border-box; /* Para que el padding no afecte al ancho total */
      position: fixed;
    }
                    
                        /* Tools Navbar */
                        .tools-navbar {
                          background-color: #343a40;
                          color: white;
                          display: flex;
                          padding: 10px;
                          gap: 10px;
                          align-items: center;
                          flex-wrap: wrap;
                        }
                    
                        .tools-navbar button {
                          background-color: #007BFF;
                          color: white;
                          border: none;
                          padding: 5px 10px;
                          cursor: pointer;
                          border-radius: 5px;
                          margin-bottom: 5px;
                        }
                    
                        .tools-navbar button:disabled {
                          background-color: #6c757d;
                          cursor: not-allowed;
                        }
                    
                        .tools-navbar button:hover:not(:disabled) {
                          background-color: #0056b3;
                        }
                    
                        /* Table with Pagination */
                        .table-container {
                          flex: 1;
                          overflow-y: auto;
                          padding: 10px;
                        }
                    
                        table {
                          width: 100%;
                          border-collapse: collapse;
                        }
                    
                        table th, table td {
                          border: 1px solid #ddd;
                          padding: 8px;
                          text-align: left;
                        }
                    
                        table th {
                          background-color: #007BFF;
                          color: white;
                        }
                    
                        .pagination {
                          display: flex;
                          justify-content: center;
                          padding: 10px 0;
                        }
                    
                        .pagination button {
                          background-color: #007BFF;
                          color: white;
                          border: none;
                          padding: 5px 10px;
                          margin: 0 5px;
                          cursor: pointer;
                          border-radius: 5px;
                        }
                    
                        .pagination button:disabled {
                          background-color: #6c757d;
                          cursor: not-allowed;
                        }
                    
                        .pagination button:hover:not(:disabled) {
                          background-color: #0056b3;
                        }
                    
                        /* RESPONSIVE DESIGN */
                        @media (max-width: 768px) {
                          .main {
                            flex-direction: column;
                          }
                    
                          .sidebar {
                            width: 100%;
                            order: 2;
                          }
                    
                          .content {
                            order: 1;
                          }
                    
                          .tools-navbar {
                            flex-wrap: wrap;
                            justify-content: center;
                          }
                    
                          .table-container {
                            padding: 5px;
                          }
                    
                          table th, table td {
                            font-size: 12px;
                          }
                    
                          .pagination button {
                            padding: 5px;
                            font-size: 12px;
                          }
                        }
                    
                        @media (max-width: 480px) {
                          .tools-navbar {
                            gap: 5px;
                          }
                    
                          table th, table td {
                            font-size: 10px;
                            padding: 5px;
                          }
                        }
                        
                        
    /* Media query para pantallas pequeñas (móviles) */
    @media (max-width: 768px) {
      .menu-toggle {
        display: flex;
        justify-content: flex-end;
      }

      .sidebar {
        left: auto;
        right: -300px; /* Oculta la sidebar en móviles */
        box-shadow: -3px 0 5px rgba(0, 0, 0, 0.2);
      }

      .menu-toggle input:checked ~ .sidebar {
        right: 0; /* Muestra la sidebar a la derecha en móviles */
      }
    }
                        
                      </style>
                    </head>
                    <body>
                      <!-- Navbar -->
                      <div class="navbar">
                      <p></p>
                          <!-- Tools Navbar -->
                          <div class="tools-navbar">
                            <label style="font-size: 30px"><i>Ventana</i>: ' . $windowInfo['name'] . '</label>
                          </div>
                          
                      </div>

                      <!-- Main Layout -->
                      <div class="main">
                    
                        <!-- Content Area -->
                        <div id="divContentForIframe2" class="content"></div>';
                        
                        
            $html .= '<div id="dynamic" class="sidebar"><ul id="menu_ul">';
            foreach ($menuItems as $item1) {
                if (isset($item1['subtabs']) && !empty($item1['subtabs'])) {
                    $html .= '<li id="' . $item1['code'] . '_li1" style="text-align: left;">
                                <label for="' . $item1['code'] . '_label1" style="background-color: #248DFF; color: white;">' . $item1['name'] . '</label>
                                <input type="checkbox" id="' . $item1['code'] . '_label1" style="list-style-type: none;">';
                    $htmlxx .= '<a id="' . $item1['code'] . '_a1" onclick="getTab(' . $item1['code'] . ') style="background-color: #248DFF; color: white;">' . $item1['name'] . '</a>';
                    $html .= '<ul id="' . $item1['code'] . '_ul1">';
                    foreach ($item1['subtabs'] as $item2) {
                        if (isset($item2['subtabs']) && !empty($item2['subtabs'])) {
                            $html .= '<li id="' . $item2['code'] . '_li2" style="display: list-item;">
                                        <label for="' . $item2['code'] . '_label2" style="background-color: #48A0FF; color: white;">' . $item2['name'] . '</label>
                                        <input type="checkbox" id="' . $item2['code'] . '_label2">';
                            $htmlxx .= '<a id="' . $item2['code'] . '_a2" onclick="getTab(' . $item2['code'] . ')" style="background-color: #48A0FF; color: white;">' . $item2['name'] . '</a>';
                            $html .= '<ul id="' . $item2['code'] . '_ul2" style="list-style-type: none;">';
                            foreach ($item2['subtabs'] as $item3) {
                                if (isset($item3['subtabs']) && !empty($item3['subtabs'])) {
                                    $html .= '<li id="' . $item3['code'] . '_li3" style="display: list-item;">
                                                <label for="' . $item3['code'] . '_label3" style="background-color: #6DB3FF; color: white; display: none;">' . $item3['name'] . '</label>
                                                <input type="checkbox" id="' . $item3['code'] . '_label3">';
                                    $html .= '<ul id="' . $item3['code'] . '_ul3" style="list-style-type: none;">';
                                    foreach ($item3['subtabs'] as $item4) {
                                        if (isset($item4['subtabs']) && !empty($item4['subtabs'])) {
                                            $html .= '<li id="' . $item4['code'] . '_li4" style="display: list-item;">
                                                        <label for="' . $item4['code'] . '_label4" style="background-color: #91C6FF; color: white; display: none;">' . $item4['name'] . '</label>
                                                        <input type="checkbox" code="' . $item4['code'] . '_label4">';
                                            $html .= '<ul id="' . $item4['code'] . '_ul4" style="list-style-type: none;">';
                                            foreach ($item4['subtabs'] as $item5) {
                                                $html .= '<li id="' . $item5['code'] . '_li5" style="display: list-item;">
                                                            <a id="' . $item5['code'] . '_a5" onclick="getTab(' . $item5['code'] . ', 0, 0, 10, `{}`)"  style="background-color: #B6D9FF; color: white;">' . $item5['name'] . '</a>
                                                        </li>';
                                            }
                                            $html .=  '</ul>';
                                        } else {
                                            $html .= '<a id="' . $item4['code'] . '_a4" onclick="getTab(' . $item5['code'] . ', 0, 0, 10, `{}`)" style="background-color: #91C6FF; color: white;">' . $item4['name'] . '</a>';
                                        }
                                        $html .=  '</li>';
                                    }
                                    $html .=  '</ul>';
                                } else {
                                    $html .= '<a id="' . $item3['code'] . '_a3" onclick="getTab(' . $item5['code'] . ', 0, 0, 10, `{}`)" style="background-color: #6DB3FF; color: white;">' . $item3['name'] . '</a>';
                                }
                                $html .=  '</li>';
                            }
                            $html .=  '</ul>';
                        } else {
                            $html .= '<a id="' . $item2['code'] . '_a2" onclick="getTab(' . $item5['code'] . ', 0, 0, 10, `{}`)" style="background-color: #48A0FF; color: white;">' . $item2['name'] . '</a>';
                        }
                        $html .=  '</li>';
                    }
                    $html .=  '</ul>';
                } else {
                    $html .= '<a id="' . $item1['code'] . '_a1" onclick="getTab(' . $item5['code'] . ', 0, 0, 10, `{}`)" style="background-color: #248DFF; color: white;">' . $item1['name'] . '</a>';
                }
                $html .=  '</li>';
            }
            $html .= '</ul></div>';

            $html .= '
                        </div>
                      </div>
                    </body>
                    </html>';
            header('Content-Type: application/text');
            echo $html;
    } else {
        $response = ["data" => [
                    "code" => 401,
                    "message"=> "Credenciales inválidas (api_getWindow)"
                ]];
    }
    // Enviar la respuesta como JSON
/***********
    header('Content-Type: application/json');
    echo json_encode($response);
************/
} catch (PDOException $e) {
    // Manejo de errores
    echo json_encode(['error' => 'Error de conexion a la base de datos (apicore_getmenu)']);
    error_log("Error de conexion: (api_getWindow)" . $e->getMessage());
}
?>
