<?php
// api.php
// https://apis.kontroles.com/auth/api_role.php?p_session_id=1012517

require '../headers.php';
require '../authdb.php';


try {
    // Crear una conexion con PDO
    $dsn = "pgsql:host=" . DB_HOST . ";dbname=" . DB_NAME;
    $pdo = new PDO($dsn, DB_USER, DB_PASS, [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]);
    $stmt = $pdo->prepare("SELECT apicore_getcatalogs AS jsontxt FROM logic.apicore_getcatalogs(:p_session_id::integer, :p_tablename::text, :p_fields::text)");

    $id1 = '1012584';
    $p_table = 'm_product_category';
    $p_fields = '{"name":"", "value":""}';

    // Bind parameters securely
    $stmt->bindParam(':p_session_id',   $id1,       PDO::PARAM_INT);
    $stmt->bindParam(':p_tablename',    $p_table,   PDO::PARAM_STR);
    $stmt->bindParam(':p_fields',       $p_fields,  PDO::PARAM_STR);
    $stmt->execute();

    $result = $stmt->fetch(PDO::FETCH_ASSOC);  // Assuming you want an associative array

    if ($result) {
        // Decode the JSON string into a PHP array
        $data = json_decode($result['jsontxt'], true);

        // Access the 'data' array
        $contentsItems = $data['contents'];
        
        // Function to recursively traverse the menu items and extract data
            $html = '
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta name="theme-color" content="#4CAF50">
  <title>KontrolesPOS</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet"    href="https://pos.kontroles.com/css/styles.css">
  <link rel="manifest"      href="manifest.json">

<style>
/* General */
body {
  font-family: Arial, sans-serif;
  margin: 0;
  padding: 0;
  background-color: #f4f4f4;
}

.pos-container {
  display: flex;
  flex-direction: column;
/*  gap: 20px;    */
gap: 1em;
  padding: 10px;
}

/* Categoras */
.categories {
  display: flex;
/*  gap: 10px;  */
gap: 1em;
  overflow-x: auto; /* Habilitar scroll horizontal */
  padding: 10px;
  background-color: #ffffff;
  border-radius: 8px;
}

.category-btn {
  flex-shrink: 0;
  padding: 10px 15px;
  background-color: #007bff;
  color: #ffffff;
  border: none;
  border-radius: 8px;
  cursor: pointer;
}

.category-btn:hover {
  background-color: #0056b3;
}

/* Productos */
.products {
  display: grid;
  grid-template-columns: repeat(auto-fit, minmax(120px, 1fr));
    gap: 5px;
}

.product-card {
  background-color: gray;
  padding: 1px;
  border: 1px solid #ddd;
  border-radius: 8px;
  text-align: center;
  cursor: pointer;
}

.product-card:hover {
  background-color: #f8f8f8;
  color: blue;
}

/* Carrito */
.cart {
  background-color: #ffffff;
  padding: 10px;
  border: 1px solid #ddd;
  border-radius: 8px;
}

.cart h2 {
  margin: 0 0 10px;
}

.cart-items {
  list-style: none;
  padding: 0;
  margin: 0;
}

.cart-items li {
  margin: 5px 0;
}

.checkout-btn {
  width: 100%;
  padding: 10px;
  background-color: #28a745;
  color: #ffffff;
  border: none;
  border-radius: 8px;
  cursor: pointer;
}

.checkout-btn:hover {
  background-color: #218838;
}
    
    <div class="row mb-3">
</style>  
</head>
<body>
  <div class="pos-container container mt-4">
    <!-- Categoras -->
    <div class="categories">
        <button class="category-btn">Beb Frias</button>
        <button class="category-btn">Beb Calientes</button>
        <button class="category-btn">Snacks</button>
        <button class="category-btn">Postres</button>
        <button class="category-btn">Comida Rapida</button>
        <button class="category-btn">Ensaladas</button>
        <button class="category-btn">Sopas</button>
    </div>

    <!-- Productos -->
    <div class="container mt-4">
        <div class="products row">
            <div class="row mb-3" style="margin:0 auto;">
                <div class="product-card col-4 mt-2 btn btn-primary">Producto 1</div>
                <div class="product-card col-4 mt-2 btn btn-primary">Producto 2</div>
                <div class="product-card col-4 mt-2 btn btn-primary">Producto 3</div>
                <div class="product-card col-4 mt-2 btn btn-primary">Producto 4</div>
                <div class="product-card col-4 mt-2 btn btn-primary">Producto 5</div>
                <div class="product-card col-4 mt-2 btn btn-primary">Producto 6</div>
                <div class="product-card col-4 mt-2 btn btn-primary">Producto 7</div>
                <div class="product-card col-4 mt-2 btn btn-primary">Producto 8</div>
                <div class="product-card col-4 mt-2 btn btn-primary">Producto 9</div>
            </div>
        </div>
    </div>

    <!-- Carrito -->
    <div class="cart">
      <h2>Carrito</h2>
      <ul class="cart-items">
        <li>Producto 1 - $10</li>
        <li>Producto 2 - $5</li>
      </ul>
          <button class="checkout-btn">Pagar</button>
        </div>
      </div>
    </body>
    </html>
                    ';
            header('Content-Type: application/text');
            echo $html;
    } else {
        $response = ["data" => [
                    "code" => 401,
                    "message"=> "Credenciales inválidas (api_getTab)"
                ]];
    }
    // Enviar la respuesta como JSON
/***********
    header('Content-Type: application/json');
    echo json_encode($response);
************/
} catch (PDOException $e) {
    // Manejo de errores
    echo json_encode(['error' => 'Error de conexion a la base de datos (api_getTab)']);
    error_log("Error de conexion: (api_getTab)" . $e->getMessage());
}
?>
